//====================================================
//Saiga12, custom meshes, sounds, & Icons
//====================================================

class WeaponSaiga12 extends MarkistanCityGuns;

//+++++++++++++
//Icons
//+++++++++++++
#exec TEXTURE IMPORT NAME=BeltIconSaiga12 FILE=Textures\BeltIconSaiga12.PCX GROUP=Icons //Belt
#exec TEXTURE IMPORT NAME=InventoryIconSaiga12 FILE=Textures\InventoryIconSaiga122.PCX GROUP=Icons //Inventory

//-------------
//Sounds
//-------------
#exec AUDIO IMPORT FILE="C:\DeusEx\MarkistanCity\Sounds\Saiga12Fire.wav" NAME="Saiga12Fire" GROUP="Weapons"
#exec AUDIO IMPORT FILE="C:\DeusEx\MarkistanCity\Sounds\Saiga12Reload1.wav" NAME="Saiga12Reload" GROUP="Weapons"
#exec AUDIO IMPORT FILE="C:\DeusEx\MarkistanCity\Sounds\Saiga12Reload2.wav" NAME="Saiga12ReloadEnd" GROUP="Weapons"

//================================
// Pickup
//================================

#exec MESH IMPORT MESH=Saiga12pickup ANIVFILE=MODELS\Saiga12pickup_a.3d DATAFILE=MODELS\Saiga12pickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Saiga12pickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=Saiga12pickup SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Saiga12pickup SEQ=Saiga12Pickup STARTFRAME=0 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=SaigaGrayAlloy FILE=Textures\GrayAlloy.PCX GROUP=Skins // Gray
#exec TEXTURE IMPORT NAME=SaigaLightGrayAlloy FILE=Textures\LightGrayAlloy.PCX GROUP=Skins // Light Gray
#exec TEXTURE IMPORT NAME=SaigaDarkGrayAlloy FILE=Textures\DarkGrayAlloy.PCX GROUP=Skins // Dark Gray
#exec TEXTURE IMPORT NAME=SaigaBlackAlloy FILE=Textures\BlackAlloy.PCX GROUP=Skins // Black
#exec TEXTURE IMPORT NAME=SaigaCusMuz FILE=Textures\CusMuz.PCX GROUP=Skins // Yellow
#exec TEXTURE IMPORT NAME=SaigaGlovesTex FILE=Textures\GloveEnvMap.PCX GROUP=Skins // Yellow

#exec MESHMAP NEW   MESHMAP=Saiga12pickup MESH=Saiga12pickup
#exec MESHMAP SCALE MESHMAP=Saiga12pickup X=0.008594025 Y=0.008594025 Z=0.008594025

#exec MESHMAP SETTEXTURE MESHMAP=Saiga12pickup NUM=0 TEXTURE=SaigaLightGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=Saiga12pickup NUM=1 TEXTURE=SaigaGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=Saiga12pickup NUM=3 TEXTURE=SaigaDarkGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=Saiga12pickup NUM=4 TEXTURE=SaigaBlackAlloy

//================================
// 3rd Person
//================================

#exec MESH IMPORT MESH=Saiga123rd ANIVFILE=MODELS\Saiga123rd_a.3d DATAFILE=MODELS\Saiga123rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Saiga123rd X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=Saiga123rd SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Saiga123rd SEQ=Saiga123rd STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=Saiga123rd MESH=Saiga123rd
#exec MESHMAP SCALE MESHMAP=Saiga123rd X=0.008594025 Y=0.008594025 Z=0.008594025

#exec MESHMAP SETTEXTURE MESHMAP=Saiga123rd NUM=0 TEXTURE=SaigaLightGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=Saiga123rd NUM=1 TEXTURE=SaigaGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=Saiga123rd NUM=2 TEXTURE=SaigaDarkGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=Saiga123rd NUM=3 TEXTURE=SaigaBlackAlloy

#exec MESHMAP SETTEXTURE MESHMAP=Saiga123rd NUM=4 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=Saiga123rd NUM=5 TEXTURE=BlackMaskTex


//================================
// 1st Person
//================================

#exec MESH IMPORT MESH=Saiga121st ANIVFILE=MODELS\Saiga12_a.3d DATAFILE=MODELS\Saiga12_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Saiga121st X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=Saiga121st SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Saiga121st SEQ=Saiga121st STARTFRAME=0 NUMFRAMES=20
#exec MESH SEQUENCE MESH=Saiga121st SEQ=Select STARTFRAME=0 NUMFRAMES=6 RATE=9.5 GROUP=Select
#exec MESH SEQUENCE MESH=Saiga121st SEQ=Shoot		STARTFRAME=6	NUMFRAMES=4		RATE=10
#exec MESH SEQUENCE MESH=Saiga121st SEQ=Down		STARTFRAME=10	NUMFRAMES=4		RATE=6.66
#exec MESH SEQUENCE MESH=Saiga121st SEQ=ReloadBegin	STARTFRAME=14	NUMFRAMES=4		RATE=4
#exec MESH SEQUENCE MESH=Saiga121st SEQ=Reload		STARTFRAME=18	NUMFRAMES=2		RATE=2.4
#exec MESH SEQUENCE MESH=Saiga121st SEQ=ReloadEnd	STARTFRAME=20	NUMFRAMES=4		RATE=9.31
#exec MESH SEQUENCE MESH=Saiga121st SEQ=Idle1		STARTFRAME=6	NUMFRAMES=1		RATE=2
#exec MESH SEQUENCE MESH=Saiga121st SEQ=Idle2		STARTFRAME=6	NUMFRAMES=1		RATE=2
#exec MESH SEQUENCE MESH=Saiga121st SEQ=Idle3		STARTFRAME=6	NUMFRAMES=1	RATE=2
#exec MESH SEQUENCE MESH=Saiga121st SEQ=Still		STARTFRAME=6	NUMFRAMES=1	RATE=2

#exec MESHMAP NEW   MESHMAP=Saiga121st MESH=Saiga121st
#exec MESHMAP SCALE MESHMAP=Saiga121st X=0.008594025 Y=-0.008594025 Z=0.008594025

#exec MESHMAP SETTEXTURE MESHMAP=Saiga121st NUM=0 TEXTURE=SaigaLightGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=Saiga121st NUM=1 TEXTURE=SaigaGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=Saiga121st NUM=2 TEXTURE=SaigaDarkGrayAlloy
#exec MESHMAP SETTEXTURE MESHMAP=Saiga121st NUM=3 TEXTURE=SaigaBlackAlloy
//#exec MESHMAP SETTEXTURE MESHMAP=Saiga121st NUM=5 TEXTURE=SaigaGlovesTex
//#exec MESHMAP SETTEXTURE MESHMAP=Saiga121st NUM=6 TEXTURE=SaigaGlovesTex

#exec MESH NOTIFY MESH=Saiga121st SEQ=Shoot	TIME=0.05	FUNCTION=SwapMuzzleFlashTexture

#exec MESHMAP SETTEXTURE MESHMAP=Saiga121st NUM=4 TEXTURE=BlackMaskTex
#exec MESHMAP SETTEXTURE MESHMAP=Saiga121st NUM=5 TEXTURE=BlackMaskTex

simulated function SwapMuzzleFlashTexture()
{
   if (!bHasMuzzleFlash)
      return;

	if (Frand() < 0.5)
		MultiSkins[4] = Texture'SaigaCusMuz';
	else
		MultiSkins[5] = Texture'SaigaCusMuz';

	MuzzleFlashLight();
	SetTimer(0.1, False);
}

simulated function EraseMuzzleFlashTexture()
{
	MultiSkins[4] = Texture'BlackMaskTex';
	MultiSkins[5] = Texture'BlackMaskTex';
}

defaultproperties
{
     PenetrationPower=24
     bKnockBack=True
     KnockBackAmount=95
     LowAmmoWaterMark=12
     EnviroEffective=ENVEFF_Air
     bAutomatic=True
     ShotTime=0.700000
     BaseAccuracy=0.800000
     AmmoNames(0)=Class'DeusEx.AmmoShell'
     AmmoNames(1)=Class'DeusEx.AmmoSabot'
     AreaOfEffect=AOE_Cone
     recoilStrength=0.700000
     mpBaseAccuracy=0.800000
     mpAccurateRange=1800
     mpMaxRange=1800
     bCanHaveModReloadCount=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     AmmoName=Class'DeusEx.AmmoShell'
     bInstantHit=True
     shakemag=50.000000
     CockingSound=Sound'Saiga12Reload'
     SelectSound=Sound'DeusExSounds.Weapons.AssaultShotgunReload'
     PlayerViewMesh=LodMesh'Saiga121st'
     PickupViewMesh=LodMesh'Saiga12Pickup'
     ThirdPersonMesh=LodMesh'Saiga123rd'
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'BeltIconSaiga12'
     largeIcon=Texture'InventoryIconSaiga12'
     largeIconWidth=192
     largeIconHeight=52
     invSlotsY=1
     Description="The Saiga-12 Shotgun (this variant an automatic) is a devestating weapon on the modern battlefield, as its high fire rate and damage make it extremely  dangerous at close quarters combat."
     Mesh=LodMesh'Saiga12Pickup'
     CollisionRadius=22.500000
     CollisionHeight=3.400000
     GoverningSkill=Class'DeusEx.SkillWeaponHeavy'
     reloadTime=2.750000
     HitDamage=9
     maxRange=5000
     AccurateRange=2500
     mpReloadTime=2.500000
     mpHitDamage=9
     mpReloadCount=12
     ReloadCount=12
     PickupAmmoCount=36
     FireSound=Sound'Saiga12Fire'
     AltFireSound=Sound'Saiga12ReloadEnd'
     InventoryGroup=204
     ItemName="Saiga 12 Auto Shotgun"
     ItemArticle="a"
     invSlotsX=4
     beltDescription="SAIGA12"
     Mass=30.000000
     PlayerViewOffset=(X=20.000000,Y=-7.000000,Z=-12.000000)
     FireOffset=(X=-20.000000,Y=7.000000,Z=12.000000)
     Texture=Texture'ReflectionMapTex2'
}
